<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template name="OverviewFrame">
	<html>
	<head>
			<xsl:call-template name="ImportCSS"/>
	<title><xsl:value-of select="$title_param"></xsl:value-of></title>
	<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>

	<!--script language="JavaScript">
		function doClick(imageHref) {
		if (parent.imageFrame != null)
		   parent.imageFrame.location.href = imageHref;
		}
	</script-->
	<xsl:call-template name="ImgLoaderScript"/>
	</head>
	<body>

	<table border="0" width="100%">
	<tr>
	<td nowrap="nowrap">

	<font class="FrameItemFont">
	<a href="allclasses-frame.html#allDiagrams" target="packageFrame">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'all_diagrams'"></xsl:with-param>
		</xsl:call-template>
	</a>
	</font>
	<p/>

	<p/>
	<font class="FrameItemFont">
	<a href="allclasses-frame.html#allClasses" target="packageFrame">
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'all_classes'"></xsl:with-param>
		</xsl:call-template>
	</a>
	</font>

	<p/>
	<font size="+1" class="FrameHeadingFont">Packages</font>
	<br/>

	<xsl:variable name="packages" select="//Package | //Model"></xsl:variable>
	<font class="FrameItemFont">
	<xsl:for-each select="$packages">
		<xsl:sort select="@name"></xsl:sort>
		
		<xsl:variable name="packPath">
			<xsl:call-template name="PackageFramePath">
				<xsl:with-param name="element" select="current()"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:variable name="name" select="string(@name)"></xsl:variable>
		<!-- xsl:variable name="diagram" select=""></xsl:variable -->
		<xsl:variable name="defdiagrams" select="current()/Diagram/Property[@name='defaultDiagram']/.."></xsl:variable>
		<xsl:variable name="diagram" select="$defdiagrams[1]"></xsl:variable>
		<xsl:variable name="packDiagramPath">
			<xsl:text disable-output-escaping="yes">"</xsl:text>
			<xsl:choose>
				<xsl:when test="$diagram">
					<xsl:call-template name="DiagramMapPath">
						<!--xsl:with-param name="element" select="current()/Diagram[@name=$name]"></xsl:with-param-->
						<xsl:with-param name="element" select="$diagram"></xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>about:blank</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text disable-output-escaping="yes">"</xsl:text>
		</xsl:variable>
		
		<a href="{$packPath}" target="packageFrame" onClick="doClick({$packDiagramPath})">
		
		<xsl:value-of select="@name"></xsl:value-of>
		</a>
		<br/>
	</xsl:for-each>
	</font>
	</td>
	</tr>
	</table>
	</body>
	</html>
</xsl:template>
</xsl:stylesheet>
